# 帳票設計書 1-Issue Reporter

## 概要

本ドキュメントは、VS CodeのIssue Reporter機能における帳票出力仕様を定義するものである。Issue Reporterは、バグ報告、パフォーマンス問題、機能リクエストをGitHubに送信するためのレポートを生成する機能である。

### 本帳票の処理概要

Issue Reporterは、VS Codeユーザーが問題を効率的に報告できるようにするための帳票生成機能である。

**業務上の目的・背景**：ユーザーがVS Codeの問題を発見した際、開発チームが迅速に問題を特定・修正できるよう、環境情報や再現手順を含む構造化されたレポートを自動生成する。これにより、問題報告の品質向上と開発チームの対応効率化を実現する。

**帳票の利用シーン**：ユーザーがVS Code使用中にバグ、パフォーマンス問題、機能リクエストを報告したい場合に使用される。コマンドパレットから「Help: Report Issue」を実行するか、ヘルプメニューから「Report Issue」を選択することでアクセス可能。

**主要な出力内容**：
1. Issue Type（Bug/Performance Issue/Feature Request）
2. Issue Description（問題の詳細説明）
3. VS Code Version情報
4. OS Version情報
5. System Info（CPU、GPU、メモリ、プロセス引数等）
6. Process Info（パフォーマンス問題時）
7. Workspace Info（パフォーマンス問題時）
8. Extensions Info（有効な拡張機能一覧）
9. A/B Experiments Info
10. Extension Data（拡張機能固有のデータ）

**帳票の出力タイミング**：ユーザーが「Create on GitHub」または「Preview on GitHub」ボタンをクリックした際に、Markdown形式のレポートが生成され、GitHubのIssue作成ページに送信される。

**帳票の利用者**：VS Codeユーザー（問題報告者）、VS Code開発チーム（問題対応者）

## 帳票種別

診断レポート / バグレポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Issue Reporter Window | `workbench.action.openIssueReporter` | Create on GitHub / Preview on GitHub ボタン |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Markdown（GitHub Issue形式） |
| 用紙サイズ | N/A（Web送信） |
| 向き | N/A |
| ファイル名 | N/A（URLパラメータとして送信） |
| 出力方法 | GitHub Issue作成ページへのURL送信 |
| 文字コード | UTF-8 |

### URL制限

| 項目 | 内容 |
|-----|------|
| 最大URL長 | 7,500文字 |
| 拡張機能データ上限 | 60,000文字 |
| 超過時の対応 | クリップボードにコピーしてユーザーに貼り付けを依頼 |

## 帳票レイアウト

### レイアウト概要

Issue Reporterが生成するMarkdownは、HTMLタグとMarkdown記法を組み合わせた構造化されたレポートである。

```
┌─────────────────────────────────────┐
│          Issue Type/Title           │
├─────────────────────────────────────┤
│         Issue Description           │
├─────────────────────────────────────┤
│          Version Info               │
│    (VS Code Version, OS Version)    │
├─────────────────────────────────────┤
│   System Info (collapsible block)   │
├─────────────────────────────────────┤
│  Process Info (collapsible block)   │
├─────────────────────────────────────┤
│ Workspace Info (collapsible block)  │
├─────────────────────────────────────┤
│ Extensions Info (collapsible block) │
├─────────────────────────────────────┤
│ A/B Experiments (collapsible block) │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Issue Type | バグ/パフォーマンス/機能リクエスト | IssueReporterData.issueType | `Type: <b>{type}</b>` |
| 2 | Issue Description | ユーザー入力の問題説明 | IssueReporterData.issueDescription | プレーンテキスト |
| 3 | Extension Version | 拡張機能のバージョン（拡張機能起因時） | selectedExtension.version | `Extension version: {version}` |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 条件 |
|----|-------|------|-------------|---------|-----|
| 1 | VS Code Version | VS Codeのバージョン情報 | versionInfo.vscodeVersion | `VS Code version: {version}` | 常時 |
| 2 | OS Version | OSのバージョン情報 | versionInfo.os | `OS version: {os}` | 常時 |
| 3 | Modes | 動作モード | restrictedMode, isUnsupported | `Modes: {modes}` | モードがある場合 |
| 4 | Remote OS | リモートOSバージョン | systemInfo.remoteData | `Remote OS version: {os}` | リモート接続時 |

### System Info部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | CPUs | CPU情報 | systemInfo.cpus | テーブル形式 |
| 2 | GPU Status | GPU状態 | systemInfo.gpuStatus | キー: 値 形式 |
| 3 | Load (avg) | 平均負荷 | systemInfo.load | テーブル形式 |
| 4 | Memory (System) | システムメモリ | systemInfo.memory | テーブル形式 |
| 5 | Process Argv | プロセス引数 | systemInfo.processArgs | テーブル形式 |
| 6 | Screen Reader | スクリーンリーダー状態 | systemInfo.screenReader | テーブル形式 |
| 7 | VM | 仮想マシン判定 | systemInfo.vmHint | テーブル形式 |

### Extensions部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Extension | 拡張機能名 | enabledNonThemeExtesions[].name | テーブル形式 |
| 2 | Author | 作成者（3文字に切り詰め） | enabledNonThemeExtesions[].publisher | テーブル形式 |
| 3 | Version | バージョン | enabledNonThemeExtesions[].version | テーブル形式 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Generated By | 生成元表記 | 固定値 | `<!-- generated by issue reporter -->` |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Issue Type | Bug/PerformanceIssue/FeatureRequestのいずれか | Yes |
| Issue Description | ユーザー入力の問題説明（10文字以上） | Yes |
| Issue Title | Issue件名 | Yes |

### 情報の包含条件

| 情報種別 | Bug | Performance Issue | Feature Request |
|---------|-----|------------------|-----------------|
| System Info | Yes | Yes | No |
| Process Info | No | Yes | No |
| Workspace Info | No | Yes | No |
| Extensions Info | Yes | Yes | No |
| Experiments Info | Yes | Yes | No |
| Extension Data | Yes | Yes | No |

### 改ページ条件

N/A（Web出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | ローカルシステム情報を直接取得 | - |

### データ取得元

#### SystemInfo

| 参照項目 | 帳票項目との対応 | 取得方法 | 備考 |
|---------|----------------|---------|------|
| cpus | CPUs | diagnostics API | CPU情報 |
| gpuStatus | GPU Status | diagnostics API | GPU状態マップ |
| load | Load (avg) | diagnostics API | システム負荷 |
| memory | Memory (System) | diagnostics API | メモリ情報 |
| processArgs | Process Argv | diagnostics API | 起動引数 |
| screenReader | Screen Reader | diagnostics API | アクセシビリティ |
| vmHint | VM | diagnostics API | VM判定 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| テーマ拡張機能数 | allExtensions.filter(isTheme).length | なし | 表示から除外される拡張機能数 |
| 有効な非テーマ拡張機能 | allExtensions.filter(!isTheme && !isBuiltin) | なし | 一覧表示対象 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ユーザーがIssue Reporterを開く] --> B[Issue Type選択]
    B --> C[Issue Source選択]
    C --> D{拡張機能起因?}
    D -->|Yes| E[拡張機能選択]
    D -->|No| F[問題説明入力]
    E --> F
    F --> G[システム情報自動収集]
    G --> H{入力検証}
    H -->|Invalid| I[エラー表示]
    I --> F
    H -->|Valid| J[serialize実行]
    J --> K{URL長チェック}
    K -->|>7500| L[クリップボードにコピー]
    K -->|<=7500| M[GitHub URL生成]
    L --> M
    M --> N{GitHub認証あり?}
    N -->|Yes| O[API経由でIssue作成]
    N -->|No| P[ブラウザでプレビュー]
    O --> Q[完了]
    P --> Q
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 入力なし | Issue Titleが空 | issue-title-empty-error | 必須入力 |
| 入力なし | Descriptionが空 | description-empty-error | 必須入力 |
| 入力不足 | Descriptionが10文字未満 | description-short-error | 10文字以上入力 |
| 拡張機能未選択 | 拡張機能起因選択時に未選択 | extension-selection-validation-error | 拡張機能を選択 |
| 拡張機能URL不正 | GitHubリポジトリURLなし | extension-selection-validation-error-no-url | 外部URLで報告 |
| URL長超過 | URL > 7500文字 | pasteData | クリップボードから貼り付け |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件/レポート |
| 目標出力時間 | 3秒以内（システム情報収集含む） |
| 同時出力数上限 | 1件（単一ウィンドウ） |

## セキュリティ考慮事項

- GitHub Access Tokenはローカルに保持され、API通信時のみ使用
- プライベートリポジトリへの報告はprivateUri経由で別途処理
- プロセス引数にはパスワード等の機密情報が含まれる可能性があるため、ユーザーが確認可能
- 拡張機能データが60,000文字を超える場合はファイルダウンロード形式に切り替え

## 備考

- Issue Reporterは新規ウィンドウとして表示される（electron環境）またはブラウザ内ウィンドウ（Web環境）
- GitHub認証済みの場合は直接Issue作成が可能
- 類似Issue検索機能により重複報告を防止

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Issue Reporterのデータ構造を理解することが、帳票出力内容を把握する第一歩である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | issue.ts | `src/vs/workbench/contrib/issue/common/issue.ts` | IssueType enum（行20-24）、IssueReporterData interface（行67-82）を確認 |
| 1-2 | issueReporterModel.ts | `src/vs/workbench/contrib/issue/browser/issueReporterModel.ts` | IssueReporterData interface（行15-48）でレポートに含まれる全データ項目を確認 |

**読解のコツ**: TypeScriptのinterfaceとenumがデータ構造の定義であり、どのような情報がレポートに含まれるかを示している。

#### Step 2: エントリーポイントを理解する

Issue Reporterの起動から表示までの流れを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | issue.ts | `src/vs/workbench/contrib/issue/common/issue.ts` | IIssueFormService interface（行92-102）でサービスのAPI仕様を確認 |
| 2-2 | baseIssueReporterService.ts | `src/vs/workbench/contrib/issue/browser/baseIssueReporterService.ts` | コンストラクタ（行78-201）で初期化処理、updateButtonStates（行220-263）でボタン状態管理を確認 |

**主要処理フロー**:
1. **行78-109**: IssueReporterModelの初期化とデータ設定
2. **行135-149**: Create/Preview/Privateアクションの定義
3. **行568-749**: イベントハンドラの設定

#### Step 3: レポート生成ロジックを理解する

Markdownレポートの生成ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | issueReporterModel.ts | `src/vs/workbench/contrib/issue/browser/issueReporterModel.ts` | serialize()メソッド（行85-104）がレポート本体を生成 |

**主要処理フロー**:
- **行85-104**: serialize()でMarkdown形式のレポート全体を構築
- **行106-113**: getRemoteOSes()でリモートOS情報を取得
- **行191-236**: generateSystemInfoMd()でシステム情報テーブルを生成
- **行238-248**: generateProcessInfoMd()でプロセス情報を生成
- **行250-260**: generateWorkspaceInfoMd()でワークスペース情報を生成
- **行274-298**: generateExtensionsMd()で拡張機能テーブルを生成

#### Step 4: Issue送信処理を理解する

GitHub APIへの送信またはURLプレビューの処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | baseIssueReporterService.ts | `src/vs/workbench/contrib/issue/browser/baseIssueReporterService.ts` | createIssue()メソッド（行1233-1314）でIssue作成処理、submitToGitHub()（行1207-1231）でAPI送信 |

**主要処理フロー**:
- **行1233-1244**: 入力検証
- **行1277-1278**: タイトルとボディの取得
- **行1291-1293**: GitHub API経由での直接作成
- **行1296-1311**: URLエンコードとURL長チェック

### プログラム呼び出し階層図

```
openReporter (IWorkbenchIssueService)
    │
    ├─ BaseIssueReporterService (constructor)
    │      ├─ IssueReporterModel (initialize)
    │      ├─ handleExtensionData()
    │      ├─ setUpTypes()
    │      └─ updateButtonStates()
    │
    ├─ setEventHandlers()
    │      └─ addEventListener() for various inputs
    │
    └─ createIssue()
           ├─ validateInputs()
           ├─ IssueReporterModel.serialize()
           │      ├─ getIssueTypeTitle()
           │      ├─ getExtensionVersion()
           │      ├─ getRemoteOSes()
           │      └─ getInfos()
           │             ├─ generateSystemInfoMd()
           │             ├─ generateProcessInfoMd()
           │             ├─ generateWorkspaceInfoMd()
           │             ├─ generateExtensionsMd()
           │             └─ generateExperimentsInfoMd()
           │
           ├─ submitToGitHub() (if authenticated)
           │
           └─ openLink() (if preview)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

User Input          ┌─────────────────────┐
 (Title,           │                     │
  Description) ────▶│ IssueReporterModel  │
                   │                     │
System Info ───────▶│   - serialize()     │──────▶ Markdown Report
                   │   - generateXxxMd() │
Process Info ──────▶│                     │
                   │                     │
Workspace Info ────▶│                     │──────▶ GitHub Issue
                   │                     │        (via API or URL)
Extensions ────────▶│                     │
                   └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| issue.ts | `src/vs/workbench/contrib/issue/common/issue.ts` | ソース | インターフェース・型定義 |
| issueReporterModel.ts | `src/vs/workbench/contrib/issue/browser/issueReporterModel.ts` | ソース | データモデルとシリアライズ |
| baseIssueReporterService.ts | `src/vs/workbench/contrib/issue/browser/baseIssueReporterService.ts` | ソース | UIロジックとイベント処理 |
| issueReporterService.ts | `src/vs/workbench/contrib/issue/browser/issueReporterService.ts` | ソース | ブラウザ環境向け実装 |
| issueService.ts | `src/vs/workbench/contrib/issue/browser/issueService.ts` | ソース | サービス登録 |
| issueFormService.ts | `src/vs/workbench/contrib/issue/browser/issueFormService.ts` | ソース | フォームサービス実装 |
| issueReporterUtil.ts | `src/vs/workbench/contrib/issue/common/issueReporterUtil.ts` | ソース | ユーティリティ関数 |
| issue.contribution.ts | `src/vs/workbench/contrib/issue/browser/issue.contribution.ts` | ソース | コマンド登録 |
